
local assets=
{
	Asset("ANIM", "anim/drop_firehammer.zip"),
    Asset("ANIM", "anim/firehammer.zip"), 
    Asset("ATLAS", "images/inventoryimages/firehammer.xml"),
}

local prefabs = 
{
    "axe", 
}
local function onfinished(inst)
  inst:Remove()
end

local function onattack(weapon, attacker, target)
    --target may be killed or removed in combat damage phase
    if target ~= nil and target:IsValid() and target.components.burnable ~= nil and math.random() < TUNING.TORCH_ATTACK_IGNITE_PERCENT * target.components.burnable.flammability  then
        target.components.burnable:Ignite(nil, attacker)
    end
end



local function fn()
local inst = CreateEntity()
local sp = 0
local function onequip(inst, owner) 
    owner.AnimState:OverrideSymbol("swap_object", "firehammer", "firehammer")
	owner.SoundEmitter:PlaySound("dontstarve/wilson/equip_item_gold")
    owner.AnimState:Show("ARM_carry") 
    owner.AnimState:Hide("ARM_normal") 
	owner.components.combat:SetAttackPeriod(1)
	sp = 1
	if sp == 1 then owner.components.combat:SetAttackPeriod(1) end
	end
	local function onunequip(inst, owner) 
    owner.AnimState:Hide("ARM_carry") 
    owner.AnimState:Show("ARM_normal")
	sp = 0
	owner.components.combat:SetAttackPeriod(TUNING.WILSON_ATTACK_PERIOD)
end
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
    MakeInventoryPhysics(inst)

	inst.entity:AddTransform()
	inst.entity:AddAnimState()
	inst.entity:AddSoundEmitter()
    inst.entity:AddNetwork()
	
	inst.AnimState:SetBank("drop_firehammer")
    inst.AnimState:SetBuild("drop_firehammer")
    inst.AnimState:PlayAnimation("idle")
	
	if not TheWorld.ismastersim then
        return inst
    end
	inst:AddComponent("weapon")
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "firehammer"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/firehammer.xml"
     
    inst:AddComponent("equippable")
	inst.components.equippable:SetOnEquip(onequip)
	inst.components.equippable:SetOnUnequip(onunequip)
		
	inst:AddComponent("inspectable")
			
 	inst:AddComponent("tool") 
    inst.components.tool:SetAction(ACTIONS.HAMMER, 2)
    inst.components.weapon:SetDamage(75)
	inst.components.weapon:SetOnAttack(onattack)
	inst:AddComponent("finiteuses")
	inst.components.finiteuses:SetMaxUses(100)
	inst.components.finiteuses:SetUses(100)
	inst.components.finiteuses:SetConsumption(ACTIONS.HAMMER, 1)
	inst.components.finiteuses:SetOnFinished(onfinished)
	local function onsave(inst, data)
    data.sp = sp
end
local function onload (inst, data)
    if data ~= nil
     then
		sp = data.sp
		
	end
		end
inst.OnSave = onsave
inst.OnLoad = onload
    return inst
end
return Prefab("firehammer", fn, assets)